/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.AtlasData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TileDataHandler {
    private static final String ATLAS_DATA_PREFIX = "aAtlas_";
    private final Map<String, AtlasData> atlasDataClientCache = new ConcurrentHashMap<String, AtlasData>();

    public AtlasData getData(int atlasID, Level world) {
        String key = this.getAtlasDataKey(atlasID);
        if (world.f_46443_) {
            return this.atlasDataClientCache.computeIfAbsent(key, s -> new AtlasData());
        }
        DimensionDataStorage manager = ((ServerLevel)world).m_8895_();
        return (AtlasData)manager.m_164861_(AtlasData::fromNbt, AtlasData::new, key);
    }

    private String getAtlasDataKey(int atlasID) {
        return ATLAS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean isRemote) {
        this.atlasDataClientCache.clear();
    }
}

